/*
 * Decompiled with CFR 0.152.
 */
package ec.rule.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.rule.RuleDefaults;
import ec.rule.RuleIndividual;
import ec.rule.RuleInitializer;
import ec.rule.RuleSet;
import ec.util.Parameter;

public class RuleCrossoverPipeline
extends BreedingPipeline {
    public static final String P_TOSS = "toss";
    public static final String P_CROSSOVER = "xover";
    public static final String P_CROSSOVERPROB = "crossover-prob";
    public static final int INDS_PRODUCED = 2;
    public static final int NUM_SOURCES = 2;
    public boolean tossSecondParent;
    public double ruleCrossProbability;
    RuleIndividual[] parents = new RuleIndividual[2];

    public Parameter defaultBase() {
        return RuleDefaults.base().push(P_CROSSOVER);
    }

    public int numSources() {
        return 2;
    }

    public Object clone() {
        RuleCrossoverPipeline c = (RuleCrossoverPipeline)super.clone();
        c.parents = (RuleIndividual[])this.parents.clone();
        return c;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.tossSecondParent = state.parameters.getBoolean(base.push(P_TOSS), def.push(P_TOSS), false);
        this.ruleCrossProbability = state.parameters.getDoubleWithDefault(base.push(P_CROSSOVERPROB), def.push(P_CROSSOVERPROB), 0.5);
        if (this.ruleCrossProbability > 1.0 || this.ruleCrossProbability < 0.0) {
            state.output.fatal("Rule cross probability must be between 0 and 1", base.push(P_CROSSOVERPROB), def.push(P_CROSSOVERPROB));
        }
    }

    public int typicalIndsProduced() {
        return this.tossSecondParent ? 1 : 2;
    }

    public int produce(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int n;
        int n2 = n = this.tossSecondParent ? 1 : 2;
        if (n < min) {
            n = min;
        }
        if (n > max) {
            n = max;
        }
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            return this.reproduce(n, start, subpopulation, inds, state, thread, true);
        }
        RuleInitializer initializer = (RuleInitializer)state.initializer;
        int q = start;
        while (q < n + start) {
            if (this.sources[0] == this.sources[1]) {
                this.sources[0].produce(2, 2, 0, subpopulation, this.parents, state, thread);
                if (!(this.sources[0] instanceof BreedingPipeline)) {
                    this.parents[0] = (RuleIndividual)this.parents[0].clone();
                    this.parents[1] = (RuleIndividual)this.parents[1].clone();
                }
            } else {
                this.sources[0].produce(1, 1, 0, subpopulation, this.parents, state, thread);
                this.sources[1].produce(1, 1, 1, subpopulation, this.parents, state, thread);
                if (!(this.sources[0] instanceof BreedingPipeline)) {
                    this.parents[0] = (RuleIndividual)this.parents[0].clone();
                }
                if (!(this.sources[1] instanceof BreedingPipeline)) {
                    this.parents[1] = (RuleIndividual)this.parents[1].clone();
                }
            }
            this.parents[0].preprocessIndividual(state, thread);
            this.parents[1].preprocessIndividual(state, thread);
            if (this.parents[0].rulesets.length != this.parents[1].rulesets.length) {
                state.output.fatal("The number of rule sets should be identical in both parents ( " + this.parents[0].rulesets.length + " : " + this.parents[1].rulesets.length + " ).");
            }
            for (int x = 0; x < this.parents[0].rulesets.length; ++x) {
                RuleSet[] temp = new RuleSet[2];
                while (true) {
                    for (int i = 0; i < 2; ++i) {
                        temp[i] = new RuleSet();
                    }
                    temp = this.parents[0].rulesets[x].splitIntoTwo(state, thread, temp, this.ruleCrossProbability);
                    temp = this.parents[1].rulesets[x].splitIntoTwo(state, thread, temp, 1.0 - this.ruleCrossProbability);
                    if (temp[0].numRules >= this.parents[0].rulesets[x].constraints((RuleInitializer)initializer).minSize && temp[0].numRules <= this.parents[0].rulesets[x].constraints((RuleInitializer)initializer).maxSize && temp[1].numRules >= this.parents[1].rulesets[x].constraints((RuleInitializer)initializer).minSize && temp[1].numRules <= this.parents[1].rulesets[x].constraints((RuleInitializer)initializer).maxSize) break;
                    temp = new RuleSet[2];
                }
                this.parents[0].rulesets[x].copyNoClone(temp[1]);
                this.parents[1].rulesets[x].copyNoClone(temp[0]);
            }
            this.parents[0].postprocessIndividual(state, thread);
            this.parents[1].postprocessIndividual(state, thread);
            this.parents[0].evaluated = false;
            this.parents[1].evaluated = false;
            inds[q] = this.parents[0];
            if (++q >= n + start || this.tossSecondParent) continue;
            inds[q] = this.parents[1];
            ++q;
        }
        return n;
    }
}

