/*
 * Decompiled with CFR 0.152.
 */
package ec.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Lexer {
    public static final int FAILURE = -1;
    CharSequence input;
    int position = 0;
    Matcher[] matchers;
    String[] regexps;
    int matchingIndex = -1;

    public Lexer(CharSequence input, String[] regexps) {
        this.regexps = regexps;
        this.matchers = new Matcher[regexps.length];
        for (int i = 0; i < regexps.length; ++i) {
            this.matchers[i] = Pattern.compile(regexps[i]).matcher(input);
        }
        this.input = input;
    }

    public String nextToken(boolean trim) {
        for (int i = 0; i < this.regexps.length; ++i) {
            if (!this.matchers[i].region(this.position, this.input.length()).lookingAt()) continue;
            this.position = this.matchers[i].end();
            this.matchingIndex = i;
            return trim ? this.matchers[i].group().trim() : this.matchers[i].group();
        }
        this.matchingIndex = -1;
        return null;
    }

    public String nextToken() {
        return this.nextToken(true);
    }

    public int getMatchingIndex() {
        return this.matchingIndex;
    }

    public String getMatchingRule() {
        if (this.matchingIndex == -1) {
            return null;
        }
        return this.regexps[this.matchingIndex];
    }

    public int getMatchingPosition() {
        return this.position;
    }
}

