/*
 * Decompiled with CFR 0.152.
 */
package ec.vector;

import ec.EvolutionState;
import ec.Individual;
import ec.util.Code;
import ec.util.DecodeReturn;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;
import ec.vector.FloatVectorSpecies;
import ec.vector.VectorDefaults;
import ec.vector.VectorIndividual;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;

public class FloatVectorIndividual
extends VectorIndividual {
    public static final String P_FloatVectorIndividual = "float-vect-ind";
    public static final double MAXIMUM_SHORT_IN_FLOAT = 1.6777216E7;
    public float[] genome;

    public Parameter defaultBase() {
        return VectorDefaults.base().push(P_FloatVectorIndividual);
    }

    public Object clone() {
        FloatVectorIndividual myobj = (FloatVectorIndividual)super.clone();
        myobj.genome = (float[])this.genome.clone();
        return myobj;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        if (!(this.species instanceof FloatVectorSpecies)) {
            state.output.fatal("FloatVectorIndividual requires a FloatVectorSpecies", base, def);
        }
        FloatVectorSpecies s = (FloatVectorSpecies)this.species;
        this.genome = new float[s.genomeSize];
    }

    public void defaultCrossover(EvolutionState state, int thread, VectorIndividual ind) {
        FloatVectorSpecies s = (FloatVectorSpecies)this.species;
        FloatVectorIndividual i = (FloatVectorIndividual)ind;
        int len = Math.min(this.genome.length, i.genome.length);
        if (len != this.genome.length || len != i.genome.length) {
            state.output.warnOnce("Genome lengths are not the same.  Vector crossover will only be done in overlapping region.");
        }
        switch (s.crossoverType) {
            case 0: {
                int point = state.random[thread].nextInt(len / s.chunksize);
                for (int x = 0; x < point * s.chunksize; ++x) {
                    float tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 2: {
                int point = state.random[thread].nextInt(len / s.chunksize - 1) + 1;
                for (int x = 0; x < point * s.chunksize; ++x) {
                    float tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 4: {
                int point = state.random[thread].nextInt(len / s.chunksize);
                int point0 = state.random[thread].nextInt(len / s.chunksize);
                if (point0 > point) {
                    int p = point0;
                    point0 = point;
                    point = p;
                }
                for (int x = point0 * s.chunksize; x < point * s.chunksize; ++x) {
                    float tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 8: {
                int point = state.random[thread].nextInt(len / s.chunksize);
                int point0 = 0;
                while ((point0 = state.random[thread].nextInt(len / s.chunksize)) == point) {
                }
                if (point0 > point) {
                    int p = point0;
                    point0 = point;
                    point = p;
                }
                for (int x = point0 * s.chunksize; x < point * s.chunksize; ++x) {
                    float tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 128: {
                for (int x = 0; x < len / s.chunksize; ++x) {
                    if (!state.random[thread].nextBoolean(s.crossoverProbability)) continue;
                    for (int y = x * s.chunksize; y < (x + 1) * s.chunksize; ++y) {
                        float tmp = i.genome[y];
                        i.genome[y] = this.genome[y];
                        this.genome[y] = tmp;
                    }
                }
                break;
            }
            case 256: {
                double alpha = (double)state.random[thread].nextFloat(true, true) * (1.0 + 2.0 * s.lineDistance) - s.lineDistance;
                double beta = (double)state.random[thread].nextFloat(true, true) * (1.0 + 2.0 * s.lineDistance) - s.lineDistance;
                for (int x = 0; x < len; ++x) {
                    double min = s.minGene(x);
                    double max = s.maxGene(x);
                    double t = alpha * (double)this.genome[x] + (1.0 - alpha) * (double)i.genome[x];
                    double u = beta * (double)i.genome[x] + (1.0 - beta) * (double)this.genome[x];
                    if (t < min || t > max || u < min || u > max) continue;
                    this.genome[x] = (float)t;
                    i.genome[x] = (float)u;
                }
                break;
            }
            case 512: {
                for (int x = 0; x < len; ++x) {
                    double u;
                    double max;
                    double min;
                    double t;
                    do {
                        double alpha = (double)state.random[thread].nextFloat(true, true) * (1.0 + 2.0 * s.lineDistance) - s.lineDistance;
                        double beta = (double)state.random[thread].nextFloat(true, true) * (1.0 + 2.0 * s.lineDistance) - s.lineDistance;
                        min = s.minGene(x);
                        max = s.maxGene(x);
                        t = alpha * (double)this.genome[x] + (1.0 - alpha) * (double)i.genome[x];
                        u = beta * (double)i.genome[x] + (1.0 - beta) * (double)this.genome[x];
                    } while (t < min || t > max || u < min || u > max);
                    this.genome[x] = (float)t;
                    i.genome[x] = (float)u;
                }
                break;
            }
            case 1024: {
                this.simulatedBinaryCrossover(state.random[thread], i, s.crossoverDistributionIndex);
                break;
            }
            default: {
                state.output.fatal("In FloatVectorIndividual.defaultCrossover, default case occurred when it shouldn't have");
            }
        }
    }

    public void split(int[] points, Object[] pieces) {
        int point0 = 0;
        int point1 = points[0];
        for (int x = 0; x < pieces.length; ++x) {
            pieces[x] = new float[point1 - point0];
            System.arraycopy(this.genome, point0, pieces[x], 0, point1 - point0);
            point0 = point1;
            point1 = x >= pieces.length - 2 ? this.genome.length : points[x + 1];
        }
    }

    public void join(Object[] pieces) {
        int sum = 0;
        for (int x = 0; x < pieces.length; ++x) {
            sum += ((float[])pieces[x]).length;
        }
        int runningsum = 0;
        float[] newgenome = new float[sum];
        for (int x = 0; x < pieces.length; ++x) {
            System.arraycopy(pieces[x], 0, newgenome, runningsum, ((float[])pieces[x]).length);
            runningsum += ((float[])pieces[x]).length;
        }
        this.genome = newgenome;
    }

    public void defaultMutate(EvolutionState state, int thread) {
        FloatVectorSpecies s = (FloatVectorSpecies)this.species;
        MersenneTwisterFast rng = state.random[thread];
        block7: for (int x = 0; x < this.genome.length; ++x) {
            if (!rng.nextBoolean(s.mutationProbability(x))) continue;
            float old = this.genome[x];
            for (int retries = 0; retries < s.duplicateRetries(x) + 1; ++retries) {
                switch (s.mutationType(x)) {
                    case 1: {
                        this.gaussianMutation(state, rng, s, x);
                        break;
                    }
                    case 2: {
                        this.polynomialMutation(state, rng, s, x);
                        break;
                    }
                    case 0: {
                        this.floatResetMutation(rng, s, x);
                        break;
                    }
                    case 3: {
                        this.integerResetMutation(rng, s, x);
                        break;
                    }
                    case 4: {
                        this.integerRandomWalkMutation(rng, s, x);
                        break;
                    }
                    default: {
                        state.output.fatal("In FloatVectorIndividual.defaultMutate, default case occurred when it shouldn't have");
                    }
                }
                if (this.genome[x] != old) continue block7;
            }
        }
    }

    void integerRandomWalkMutation(MersenneTwisterFast random, FloatVectorSpecies species, int index) {
        double min = species.minGene(index);
        double max = species.maxGene(index);
        if (!species.mutationIsBounded(index)) {
            max = 1.6777216E7;
            min = -max;
        }
        do {
            int n = random.nextBoolean() ? 1 : -1;
            float g = (float)Math.floor(this.genome[index]);
            if (n == 1 && (double)g < max || n == -1 && (double)g > min) {
                this.genome[index] = g + (float)n;
                continue;
            }
            if (!(n == -1 && (double)g < max) && (n != 1 || !((double)g > min))) continue;
            this.genome[index] = g - (float)n;
        } while (random.nextBoolean(species.randomWalkProbability(index)));
    }

    void integerResetMutation(MersenneTwisterFast random, FloatVectorSpecies species, int index) {
        int minGene = (int)Math.floor(species.minGene(index));
        int maxGene = (int)Math.floor(species.maxGene(index));
        this.genome[index] = this.randomValueFromClosedInterval(minGene, maxGene, random);
    }

    void floatResetMutation(MersenneTwisterFast random, FloatVectorSpecies species, int index) {
        double minGene = species.minGene(index);
        double maxGene = species.maxGene(index);
        this.genome[index] = (float)(minGene + (double)random.nextFloat(true, true) * (maxGene - minGene));
    }

    void gaussianMutation(EvolutionState state, MersenneTwisterFast random, FloatVectorSpecies species, int index) {
        double val;
        block1: {
            double min = species.minGene(index);
            double max = species.maxGene(index);
            double stdev = species.gaussMutationStdev(index);
            int outOfBoundsLeftOverTries = species.outOfBoundsRetries;
            boolean givingUpAllowed = species.outOfBoundsRetries != 0;
            do {
                val = random.nextGaussian() * stdev + (double)this.genome[index];
                --outOfBoundsLeftOverTries;
                if (!species.mutationIsBounded(index) || !(val > max) && !(val < min)) break block1;
            } while (!givingUpAllowed || outOfBoundsLeftOverTries != 0);
            val = min + (double)random.nextFloat() * (max - min);
            species.outOfRangeRetryLimitReached(state);
        }
        this.genome[index] = (float)val;
    }

    void polynomialMutation(EvolutionState state, MersenneTwisterFast random, FloatVectorSpecies species, int index) {
        double y;
        double eta_m = species.mutationDistributionIndex(index);
        boolean alternativePolynomialVersion = species.polynomialIsAlternative(index);
        double y1 = y = (double)this.genome[index];
        double yl = species.minGene(index);
        double yu = species.maxGene(index);
        double delta1 = (y - yl) / (yu - yl);
        double delta2 = (yu - y) / (yu - yl);
        int totalTries = species.outOfBoundsRetries;
        int tries = 0;
        for (tries = 0; tries < totalTries || totalTries == 0; ++tries) {
            double deltaq;
            double val;
            double xy;
            double rnd = random.nextFloat();
            double mut_pow = 1.0 / (eta_m + 1.0);
            if (rnd <= 0.5) {
                xy = 1.0 - delta1;
                val = 2.0 * rnd + (alternativePolynomialVersion ? (1.0 - 2.0 * rnd) * Math.pow(xy, eta_m + 1.0) : 0.0);
                deltaq = Math.pow(val, mut_pow) - 1.0;
            } else {
                xy = 1.0 - delta2;
                val = 2.0 * (1.0 - rnd) + (alternativePolynomialVersion ? 2.0 * (rnd - 0.5) * Math.pow(xy, eta_m + 1.0) : 0.0);
                deltaq = 1.0 - Math.pow(val, mut_pow);
            }
            y1 = y + deltaq * (yu - yl);
            if (!species.mutationIsBounded(index) || y1 >= yl && y1 <= yu) break;
        }
        if (totalTries != 0 && tries == totalTries) {
            y1 = (float)(species.minGene(index) + (double)random.nextFloat(true, true) * (species.maxGene(index) - species.minGene(index)));
            species.outOfRangeRetryLimitReached(state);
        }
        this.genome[index] = (float)y1;
    }

    public void polynomialMutate(EvolutionState state, MersenneTwisterFast random, float eta_m, boolean alternativePolynomialVersion, boolean mutationIsBounded) {
        FloatVectorSpecies s = (FloatVectorSpecies)this.species;
        float[] ind = this.genome;
        for (int j = 0; j < ind.length; ++j) {
            double y;
            if (!random.nextBoolean(s.mutationProbability[j])) continue;
            double y1 = y = (double)ind[j];
            double yl = s.minGene(j);
            double yu = s.maxGene(j);
            double delta1 = (y - yl) / (yu - yl);
            double delta2 = (yu - y) / (yu - yl);
            int totalTries = s.outOfBoundsRetries;
            int tries = 0;
            for (tries = 0; tries < totalTries || totalTries == 0; ++tries) {
                double deltaq;
                double val;
                double xy;
                double rnd = random.nextFloat();
                double mut_pow = 1.0 / ((double)eta_m + 1.0);
                if (rnd <= 0.5) {
                    xy = 1.0 - delta1;
                    val = 2.0 * rnd + (alternativePolynomialVersion ? (1.0 - 2.0 * rnd) * Math.pow(xy, (double)eta_m + 1.0) : 0.0);
                    deltaq = Math.pow(val, mut_pow) - 1.0;
                } else {
                    xy = 1.0 - delta2;
                    val = 2.0 * (1.0 - rnd) + (alternativePolynomialVersion ? 2.0 * (rnd - 0.5) * Math.pow(xy, (double)eta_m + 1.0) : 0.0);
                    deltaq = 1.0 - Math.pow(val, mut_pow);
                }
                y1 = y + deltaq * (yu - yl);
                if (!mutationIsBounded || y1 >= yl && y1 <= yu) break;
            }
            if (totalTries != 0 && tries == totalTries) {
                y1 = (float)(s.minGene(j) + (double)random.nextFloat(true, true) * (s.maxGene(j) - s.minGene(j)));
                s.outOfRangeRetryLimitReached(state);
            }
            ind[j] = (float)y1;
        }
    }

    public void simulatedBinaryCrossover(MersenneTwisterFast random, FloatVectorIndividual other, float eta_c) {
        double EPS = 1.0E-14;
        FloatVectorSpecies s = (FloatVectorSpecies)this.species;
        float[] parent1 = this.genome;
        float[] parent2 = other.genome;
        for (int i = 0; i < parent1.length; ++i) {
            double y2;
            double y1;
            if (!random.nextBoolean() || !((double)Math.abs(parent1[i] - parent2[i]) > 1.0E-14)) continue;
            if (parent1[i] < parent2[i]) {
                y1 = parent1[i];
                y2 = parent2[i];
            } else {
                y1 = parent2[i];
                y2 = parent1[i];
            }
            double yl = s.minGene(i);
            double yu = s.maxGene(i);
            double rand = random.nextFloat();
            double beta = 1.0 + 2.0 * (y1 - yl) / (y2 - y1);
            double alpha = 2.0 - Math.pow(beta, -((double)eta_c + 1.0));
            double betaq = rand <= 1.0 / alpha ? Math.pow(rand * alpha, 1.0 / ((double)eta_c + 1.0)) : Math.pow(1.0 / (2.0 - rand * alpha), 1.0 / ((double)eta_c + 1.0));
            double c1 = 0.5 * (y1 + y2 - betaq * (y2 - y1));
            beta = 1.0 + 2.0 * (yu - y2) / (y2 - y1);
            alpha = 2.0 - Math.pow(beta, -((double)eta_c + 1.0));
            betaq = rand <= 1.0 / alpha ? Math.pow(rand * alpha, 1.0 / ((double)eta_c + 1.0)) : Math.pow(1.0 / (2.0 - rand * alpha), 1.0 / ((double)eta_c + 1.0));
            double c2 = 0.5 * (y1 + y2 + betaq * (y2 - y1));
            if (c1 < yl) {
                c1 = yl;
            }
            if (c2 < yl) {
                c2 = yl;
            }
            if (c1 > yu) {
                c1 = yu;
            }
            if (c2 > yu) {
                c2 = yu;
            }
            if (random.nextBoolean()) {
                parent1[i] = (float)c2;
                parent2[i] = (float)c1;
                continue;
            }
            parent1[i] = (float)c1;
            parent2[i] = (float)c2;
        }
    }

    int randomValueFromClosedInterval(int min, int max, MersenneTwisterFast random) {
        if (max - min < 0) {
            int l = 0;
            while ((l = random.nextInt()) < min || l > max) {
            }
            return l;
        }
        return min + random.nextInt(max - min + 1);
    }

    public void reset(EvolutionState state, int thread) {
        FloatVectorSpecies s = (FloatVectorSpecies)this.species;
        MersenneTwisterFast random = state.random[thread];
        for (int x = 0; x < this.genome.length; ++x) {
            int type = s.mutationType(x);
            if (type == 3 || type == 4) {
                int minGene = (int)Math.floor(s.minGene(x));
                int maxGene = (int)Math.floor(s.maxGene(x));
                this.genome[x] = this.randomValueFromClosedInterval(minGene, maxGene, random);
                continue;
            }
            this.genome[x] = (float)(s.minGene(x) + random.nextDouble(true, true) * (s.maxGene(x) - s.minGene(x)));
        }
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash << 1 | hash >>> 31;
        for (int x = 0; x < this.genome.length; ++x) {
            hash = (hash << 1 | hash >>> 31) ^ Float.floatToIntBits(this.genome[x]);
        }
        return hash;
    }

    public String genotypeToStringForHumans() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.genome.length; ++i) {
            if (i > 0) {
                s.append(" ");
            }
            s.append(this.genome[i]);
        }
        return s.toString();
    }

    public String genotypeToString() {
        StringBuilder s = new StringBuilder();
        s.append(Code.encode(this.genome.length));
        for (int i = 0; i < this.genome.length; ++i) {
            s.append(Code.encode(this.genome[i]));
        }
        return s.toString();
    }

    protected void parseGenotype(EvolutionState state, LineNumberReader reader) throws IOException {
        String s = reader.readLine();
        DecodeReturn d = new DecodeReturn(s);
        Code.decode(d);
        if (d.type != 4) {
            state.output.fatal("Individual with genome:\n" + s + "\n... does not have an integer at the beginning indicating the genome count.");
        }
        int lll = (int)d.l;
        this.genome = new float[lll];
        for (int i = 0; i < this.genome.length; ++i) {
            Code.decode(d);
            this.genome[i] = (float)d.d;
        }
    }

    public boolean equals(Object ind) {
        if (ind == null) {
            return false;
        }
        if (!this.getClass().equals(ind.getClass())) {
            return false;
        }
        FloatVectorIndividual i = (FloatVectorIndividual)ind;
        if (this.genome.length != i.genome.length) {
            return false;
        }
        for (int j = 0; j < this.genome.length; ++j) {
            if (this.genome[j] == i.genome[j]) continue;
            return false;
        }
        return true;
    }

    public Object getGenome() {
        return this.genome;
    }

    public void setGenome(Object gen) {
        this.genome = (float[])gen;
    }

    public int genomeLength() {
        return this.genome.length;
    }

    public void writeGenotype(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.genome.length);
        for (int x = 0; x < this.genome.length; ++x) {
            dataOutput.writeFloat(this.genome[x]);
        }
    }

    public void readGenotype(EvolutionState state, DataInput dataInput) throws IOException {
        int len = dataInput.readInt();
        if (this.genome == null || this.genome.length != len) {
            this.genome = new float[len];
        }
        for (int x = 0; x < this.genome.length; ++x) {
            this.genome[x] = dataInput.readFloat();
        }
    }

    public void clamp() {
        FloatVectorSpecies _species = (FloatVectorSpecies)this.species;
        for (int i = 0; i < this.genomeLength(); ++i) {
            float minGene = (float)_species.minGene(i);
            if (this.genome[i] < minGene) {
                this.genome[i] = minGene;
                continue;
            }
            float maxGene = (float)_species.maxGene(i);
            if (!(this.genome[i] > maxGene)) continue;
            this.genome[i] = maxGene;
        }
    }

    public void setGenomeLength(int len) {
        float[] newGenome;
        System.arraycopy(this.genome, 0, newGenome, 0, this.genome.length < (newGenome = new float[len]).length ? this.genome.length : newGenome.length);
        this.genome = newGenome;
    }

    public boolean isInRange() {
        FloatVectorSpecies _species = (FloatVectorSpecies)this.species;
        for (int i = 0; i < this.genomeLength(); ++i) {
            if (!((double)this.genome[i] < _species.minGene(i)) && !((double)this.genome[i] > _species.maxGene(i))) continue;
            return false;
        }
        return true;
    }

    public double distanceTo(Individual otherInd) {
        if (!(otherInd instanceof FloatVectorIndividual)) {
            return super.distanceTo(otherInd);
        }
        FloatVectorIndividual other = (FloatVectorIndividual)otherInd;
        float[] otherGenome = other.genome;
        double sumSquaredDistance = 0.0;
        for (int i = 0; i < other.genomeLength(); ++i) {
            double dist = this.genome[i] - otherGenome[i];
            sumSquaredDistance += dist * dist;
        }
        return StrictMath.sqrt(sumSquaredDistance);
    }
}

