/*
 * Decompiled with CFR 0.152.
 */
package ec.vector;

import ec.EvolutionState;
import ec.util.Parameter;
import ec.vector.DoubleVectorIndividual;
import ec.vector.FloatVectorIndividual;
import ec.vector.VectorSpecies;

public class FloatVectorSpecies
extends VectorSpecies {
    public static final String P_MINGENE = "min-gene";
    public static final String P_MAXGENE = "max-gene";
    public static final String P_MUTATIONTYPE = "mutation-type";
    public static final String P_STDEV = "mutation-stdev";
    public static final String P_MUTATION_DISTRIBUTION_INDEX = "mutation-distribution-index";
    public static final String P_POLYNOMIAL_ALTERNATIVE = "alternative-polynomial-version";
    public static final String V_RESET_MUTATION = "reset";
    public static final String V_GAUSS_MUTATION = "gauss";
    public static final String V_POLYNOMIAL_MUTATION = "polynomial";
    public static final String V_INTEGER_RANDOM_WALK_MUTATION = "integer-random-walk";
    public static final String V_INTEGER_RESET_MUTATION = "integer-reset";
    public static final String P_RANDOM_WALK_PROBABILITY = "random-walk-probability";
    public static final String P_OUTOFBOUNDS_RETRIES = "out-of-bounds-retries";
    public static final String P_MUTATION_BOUNDED = "mutation-bounded";
    public static final int C_RESET_MUTATION = 0;
    public static final int C_GAUSS_MUTATION = 1;
    public static final int C_POLYNOMIAL_MUTATION = 2;
    public static final int C_INTEGER_RESET_MUTATION = 3;
    public static final int C_INTEGER_RANDOM_WALK_MUTATION = 4;
    protected double[] minGene;
    protected double[] maxGene;
    protected int[] mutationType;
    protected double[] gaussMutationStdev;
    protected boolean[] mutationIsBounded;
    boolean mutationIsBoundedDefined;
    protected int[] mutationDistributionIndex;
    protected boolean[] polynomialIsAlternative;
    boolean polynomialIsAlternativeDefined;
    protected double[] randomWalkProbability;
    public int outOfBoundsRetries;
    public static final int DEFAULT_OUT_OF_BOUNDS_RETRIES = 100;
    static final double SIMULATED_BINARY_CROSSOVER_EPS = 1.0E-14;

    public void outOfRangeRetryLimitReached(EvolutionState state) {
        state.output.warnOnce("The limit of 'out-of-range' retries for gaussian or polynomial mutation (100) was reached.");
    }

    public double maxGene(int gene) {
        double[] m = this.maxGene;
        if (m.length <= gene) {
            gene = m.length - 1;
        }
        return m[gene];
    }

    public double minGene(int gene) {
        double[] m = this.minGene;
        if (m.length <= gene) {
            gene = m.length - 1;
        }
        return m[gene];
    }

    public int mutationType(int gene) {
        int[] m = this.mutationType;
        if (m.length <= gene) {
            gene = m.length - 1;
        }
        return m[gene];
    }

    public double gaussMutationStdev(int gene) {
        double[] m = this.gaussMutationStdev;
        if (m.length <= gene) {
            gene = m.length - 1;
        }
        return m[gene];
    }

    public boolean mutationIsBounded(int gene) {
        boolean[] m = this.mutationIsBounded;
        if (m.length <= gene) {
            gene = m.length - 1;
        }
        return m[gene];
    }

    public int mutationDistributionIndex(int gene) {
        int[] m = this.mutationDistributionIndex;
        if (m.length <= gene) {
            gene = m.length - 1;
        }
        return m[gene];
    }

    public boolean polynomialIsAlternative(int gene) {
        boolean[] m = this.polynomialIsAlternative;
        if (m.length <= gene) {
            gene = m.length - 1;
        }
        return m[gene];
    }

    public double randomWalkProbability(int gene) {
        double[] m = this.randomWalkProbability;
        if (m.length <= gene) {
            gene = m.length - 1;
        }
        return m[gene];
    }

    public boolean inNumericalTypeRange(double geneVal) {
        if (this.i_prototype instanceof FloatVectorIndividual) {
            return geneVal <= 3.4028234663852886E38 && geneVal >= -3.4028234663852886E38;
        }
        return this.i_prototype instanceof DoubleVectorIndividual;
    }

    public void setup(EvolutionState state, Parameter base) {
        Parameter def = this.defaultBase();
        this.setupGenome(state, base);
        this.outOfBoundsRetries = state.parameters.getIntWithDefault(base.push(P_OUTOFBOUNDS_RETRIES), def.push(P_OUTOFBOUNDS_RETRIES), 100);
        if (this.outOfBoundsRetries < 0) {
            state.output.fatal("Out of bounds retries must be >= 0.", base.push(P_OUTOFBOUNDS_RETRIES), def.push(P_OUTOFBOUNDS_RETRIES));
        }
        this.minGene = new double[this.genomeSize + 1];
        this.maxGene = new double[this.genomeSize + 1];
        this.mutationType = this.fill(new int[this.genomeSize + 1], -1);
        this.gaussMutationStdev = this.fill(new double[this.genomeSize + 1], Double.NaN);
        this.mutationDistributionIndex = this.fill(new int[this.genomeSize + 1], -1);
        this.polynomialIsAlternative = new boolean[this.genomeSize + 1];
        this.mutationIsBounded = new boolean[this.genomeSize + 1];
        this.randomWalkProbability = this.fill(new double[this.genomeSize + 1], Double.NaN);
        double _minGene = state.parameters.getDoubleWithDefault(base.push(P_MINGENE), def.push(P_MINGENE), 0.0);
        double _maxGene = state.parameters.getDouble(base.push(P_MAXGENE), def.push(P_MAXGENE), _minGene);
        if (_maxGene < _minGene) {
            state.output.fatal("FloatVectorSpecies must have a default min-gene which is <= the default max-gene", base.push(P_MAXGENE), def.push(P_MAXGENE));
        }
        this.fill(this.minGene, _minGene);
        this.fill(this.maxGene, _maxGene);
        String mtype = state.parameters.getStringWithDefault(base.push(P_MUTATIONTYPE), def.push(P_MUTATIONTYPE), null);
        int _mutationType = 0;
        if (mtype == null) {
            state.output.warning("No global mutation type given for FloatVectorSpecies, assuming 'reset' mutation", base.push(P_MUTATIONTYPE), def.push(P_MUTATIONTYPE));
        } else if (mtype.equalsIgnoreCase(V_RESET_MUTATION)) {
            _mutationType = 0;
        } else if (mtype.equalsIgnoreCase(V_POLYNOMIAL_MUTATION)) {
            _mutationType = 2;
        } else if (mtype.equalsIgnoreCase(V_GAUSS_MUTATION)) {
            _mutationType = 1;
        } else if (mtype.equalsIgnoreCase(V_INTEGER_RESET_MUTATION)) {
            _mutationType = 3;
            state.output.warnOnce("Integer Reset Mutation used in FloatVectorSpecies.  Be advised that during initialization these genes will only be set to integer values.");
        } else if (mtype.equalsIgnoreCase(V_INTEGER_RANDOM_WALK_MUTATION)) {
            _mutationType = 4;
            state.output.warnOnce("Integer Random Walk Mutation used in FloatVectorSpecies.  Be advised that during initialization these genes will only be set to integer values.");
        } else {
            state.output.fatal("FloatVectorSpecies given a bad mutation type: " + mtype, base.push(P_MUTATIONTYPE), def.push(P_MUTATIONTYPE));
        }
        this.fill(this.mutationType, _mutationType);
        if (_mutationType == 2) {
            int _mutationDistributionIndex = state.parameters.getInt(base.push(P_MUTATION_DISTRIBUTION_INDEX), def.push(P_MUTATION_DISTRIBUTION_INDEX), 0);
            if (_mutationDistributionIndex < 0) {
                state.output.fatal("If FloatVectorSpecies is going to use polynomial mutation as its global mutation type, the global distribution index must be defined and >= 0.", base.push(P_MUTATION_DISTRIBUTION_INDEX), def.push(P_MUTATION_DISTRIBUTION_INDEX));
            }
            this.fill(this.mutationDistributionIndex, _mutationDistributionIndex);
            if (!state.parameters.exists(base.push(P_POLYNOMIAL_ALTERNATIVE), def.push(P_POLYNOMIAL_ALTERNATIVE))) {
                state.output.warning("FloatVectorSpecies is using polynomial mutation as its global mutation type, but alternative-polynomial-version is not defined.  Assuming 'true'");
            }
            boolean _polynomialIsAlternative = state.parameters.getBoolean(base.push(P_POLYNOMIAL_ALTERNATIVE), def.push(P_POLYNOMIAL_ALTERNATIVE), true);
            this.fill(this.polynomialIsAlternative, _polynomialIsAlternative);
            this.polynomialIsAlternativeDefined = true;
        }
        if (_mutationType == 1) {
            double _gaussMutationStdev = state.parameters.getDouble(base.push(P_STDEV), def.push(P_STDEV), 0.0);
            if (_gaussMutationStdev <= 0.0) {
                state.output.fatal("If it's going to use gaussian mutation as its global mutation type, FloatvectorSpecies must have a strictly positive standard deviation", base.push(P_STDEV), def.push(P_STDEV));
            }
            this.fill(this.gaussMutationStdev, _gaussMutationStdev);
        }
        if (_mutationType == 4) {
            double _randomWalkProbability = state.parameters.getDoubleWithMax(base.push(P_RANDOM_WALK_PROBABILITY), def.push(P_RANDOM_WALK_PROBABILITY), 0.0, 1.0);
            if (_randomWalkProbability <= 0.0) {
                state.output.fatal("If it's going to use random walk mutation as its global mutation type, FloatvectorSpecies must a random walk mutation probability between 0.0 and 1.0.", base.push(P_RANDOM_WALK_PROBABILITY), def.push(P_RANDOM_WALK_PROBABILITY));
            }
            this.fill(this.randomWalkProbability, _randomWalkProbability);
        }
        if (_mutationType == 2 || _mutationType == 1 || _mutationType == 4) {
            if (!state.parameters.exists(base.push(P_MUTATION_BOUNDED), def.push(P_MUTATION_BOUNDED))) {
                state.output.warning("FloatVectorSpecies is using gaussian, polynomial, or integer random walk mutation as its global mutation type, but mutation-bounded is not defined.  Assuming 'true'");
            }
            boolean _mutationIsBounded = state.parameters.getBoolean(base.push(P_MUTATION_BOUNDED), def.push(P_MUTATION_BOUNDED), true);
            this.fill(this.mutationIsBounded, _mutationIsBounded);
            this.mutationIsBoundedDefined = true;
        }
        super.setup(state, base);
        for (int x = 0; x < this.genomeSize + 1; ++x) {
            if (this.maxGene[x] != this.maxGene[x]) {
                state.output.fatal("FloatVectorSpecies found that max-gene[" + x + "] is NaN");
            }
            if (this.minGene[x] != this.minGene[x]) {
                state.output.fatal("FloatVectorSpecies found that min-gene[" + x + "] is NaN");
            }
            if (this.maxGene[x] < this.minGene[x]) {
                state.output.fatal("FloatVectorSpecies must have a min-gene[" + x + "] which is <= the max-gene[" + x + "]");
            }
            if (!this.inNumericalTypeRange(this.minGene[x])) {
                state.output.fatal("This FloatvectorSpecies has a prototype of the kind: " + this.i_prototype.getClass().getName() + ", but doesn't have a min-gene[" + x + "] value within the range of this prototype's genome's data types");
            }
            if (!this.inNumericalTypeRange(this.maxGene[x])) {
                state.output.fatal("This FloatvectorSpecies has a prototype of the kind: " + this.i_prototype.getClass().getName() + ", but doesn't have a max-gene[" + x + "] value within the range of this prototype's genome's data types");
            }
            if ((this.mutationType[x] == 3 || this.mutationType[x] == 4) && this.maxGene[x] != Math.floor(this.maxGene[x])) {
                state.output.fatal("Gene " + x + " is using an integer mutation method, but the max gene is not an integer (" + this.maxGene[x] + ").");
            }
            if (this.mutationType[x] != 3 && this.mutationType[x] != 4 || this.minGene[x] == Math.floor(this.minGene[x])) continue;
            state.output.fatal("Gene " + x + " is using an integer mutation method, but the min gene is not an integer (" + this.minGene[x] + ").");
        }
    }

    protected void loadParametersForGene(EvolutionState state, int index, Parameter base, Parameter def, String postfix) {
        double maxVal;
        super.loadParametersForGene(state, index, base, def, postfix);
        double minVal = state.parameters.getDoubleWithDefault(base.push(P_MINGENE).push(postfix), def.push(P_MINGENE).push(postfix), Double.NaN);
        if (minVal == minVal) {
            if (!this.inNumericalTypeRange(minVal)) {
                state.output.fatal("Min Gene Value out of range for data type " + this.i_prototype.getClass().getName(), base.push(P_MINGENE).push(postfix), base.push(P_MINGENE).push(postfix));
            } else {
                this.minGene[index] = minVal;
            }
            if (this.dynamicInitialSize) {
                state.output.warnOnce("Using dynamic initial sizing, but per-gene or per-segment min-gene declarations.  This is probably wrong.  You probably want to use global min/max declarations.", base.push(P_MINGENE).push(postfix), base.push(P_MINGENE).push(postfix));
            }
        }
        if ((maxVal = state.parameters.getDoubleWithDefault(base.push(P_MAXGENE).push(postfix), def.push(P_MAXGENE).push(postfix), Double.NaN)) == maxVal) {
            if (!this.inNumericalTypeRange(maxVal)) {
                state.output.fatal("Max Gene Value out of range for data type " + this.i_prototype.getClass().getName(), base.push(P_MAXGENE).push(postfix), base.push(P_MAXGENE).push(postfix));
            } else {
                this.maxGene[index] = maxVal;
            }
            if (this.dynamicInitialSize) {
                state.output.warnOnce("Using dynamic initial sizing, but per-gene or per-segment max-gene declarations.  This is probably wrong.  You probably want to use global min/max declarations.", base.push(P_MAXGENE).push(postfix), base.push(P_MAXGENE).push(postfix));
            }
        }
        if (maxVal == maxVal && minVal != minVal) {
            state.output.warning("Max Gene specified but not Min Gene", base.push(P_MINGENE).push(postfix), def.push(P_MINGENE).push(postfix));
        }
        if (minVal == minVal && maxVal != maxVal) {
            state.output.warning("Min Gene specified but not Max Gene", base.push(P_MAXGENE).push(postfix), def.push(P_MINGENE).push(postfix));
        }
        String mtype = state.parameters.getStringWithDefault(base.push(P_MUTATIONTYPE).push(postfix), def.push(P_MUTATIONTYPE).push(postfix), null);
        int mutType = -1;
        if (mtype != null) {
            if (mtype.equalsIgnoreCase(V_RESET_MUTATION)) {
                this.mutationType[index] = 0;
                mutType = 0;
            } else if (mtype.equalsIgnoreCase(V_POLYNOMIAL_MUTATION)) {
                this.mutationType[index] = 2;
                mutType = 2;
            } else if (mtype.equalsIgnoreCase(V_GAUSS_MUTATION)) {
                this.mutationType[index] = 1;
                mutType = 1;
            } else if (mtype.equalsIgnoreCase(V_INTEGER_RESET_MUTATION)) {
                this.mutationType[index] = 3;
                mutType = 3;
                state.output.warnOnce("Integer Reset Mutation used in FloatVectorSpecies.  Be advised that during initialization these genes will only be set to integer values.");
            } else if (mtype.equalsIgnoreCase(V_INTEGER_RANDOM_WALK_MUTATION)) {
                this.mutationType[index] = 4;
                mutType = 4;
                state.output.warnOnce("Integer Random Walk Mutation used in FloatVectorSpecies.  Be advised that during initialization these genes will only be set to integer values.");
            } else {
                state.output.fatal("FloatVectorSpecies given a bad mutation type: " + mtype, base.push(P_MUTATIONTYPE).push(postfix), def.push(P_MUTATIONTYPE).push(postfix));
            }
        }
        if (mutType == 2) {
            if (state.parameters.exists(base.push(P_MUTATION_DISTRIBUTION_INDEX).push(postfix), def.push(P_MUTATION_DISTRIBUTION_INDEX).push(postfix))) {
                this.mutationDistributionIndex[index] = state.parameters.getInt(base.push(P_MUTATION_DISTRIBUTION_INDEX).push(postfix), def.push(P_MUTATION_DISTRIBUTION_INDEX).push(postfix), 0);
                if (this.mutationDistributionIndex[index] < 0) {
                    state.output.fatal("If FloatVectorSpecies is going to use polynomial mutation as a per-gene or per-segment type, the global distribution index must be defined and >= 0.", base.push(P_MUTATION_DISTRIBUTION_INDEX).push(postfix), def.push(P_MUTATION_DISTRIBUTION_INDEX).push(postfix));
                }
            } else if (this.mutationDistributionIndex[index] != this.mutationDistributionIndex[index]) {
                state.output.fatal("If FloatVectorSpecies is going to use polynomial mutation as a per-gene or per-segment type, either the global or per-gene/per-segment distribution index must be defined and >= 0.", base.push(P_MUTATION_DISTRIBUTION_INDEX).push(postfix), def.push(P_MUTATION_DISTRIBUTION_INDEX).push(postfix));
            }
            if (state.parameters.exists(base.push(P_POLYNOMIAL_ALTERNATIVE).push(postfix), def.push(P_POLYNOMIAL_ALTERNATIVE).push(postfix))) {
                this.polynomialIsAlternative[index] = state.parameters.getBoolean(base.push(P_POLYNOMIAL_ALTERNATIVE).push(postfix), def.push(P_POLYNOMIAL_ALTERNATIVE).push(postfix), true);
            }
        }
        if (mutType == 1) {
            if (state.parameters.exists(base.push(P_STDEV).push(postfix), def.push(P_STDEV).push(postfix))) {
                this.gaussMutationStdev[index] = state.parameters.getDouble(base.push(P_STDEV).push(postfix), def.push(P_STDEV).push(postfix), 0.0);
                if (this.gaussMutationStdev[index] <= 0.0) {
                    state.output.fatal("If it's going to use gaussian mutation as a per-gene or per-segment type, it must have a strictly positive standard deviation", base.push(P_STDEV).push(postfix), def.push(P_STDEV).push(postfix));
                }
            } else if (this.gaussMutationStdev[index] != this.gaussMutationStdev[index]) {
                state.output.fatal("If FloatVectorSpecies is going to use polynomial mutation as a per-gene or per-segment type, either the global or per-gene/per-segment standard deviation must be defined.", base.push(P_STDEV).push(postfix), def.push(P_STDEV).push(postfix));
            }
        }
        if (mutType == 4) {
            if (state.parameters.exists(base.push(P_RANDOM_WALK_PROBABILITY).push(postfix), def.push(P_RANDOM_WALK_PROBABILITY).push(postfix))) {
                this.randomWalkProbability[index] = state.parameters.getDoubleWithMax(base.push(P_RANDOM_WALK_PROBABILITY).push(postfix), def.push(P_RANDOM_WALK_PROBABILITY).push(postfix), 0.0, 1.0);
                if (this.randomWalkProbability[index] <= 0.0) {
                    state.output.fatal("If it's going to use random walk mutation as a per-gene or per-segment type, FloatVectorSpecies must a random walk mutation probability between 0.0 and 1.0.", base.push(P_RANDOM_WALK_PROBABILITY).push(postfix), def.push(P_RANDOM_WALK_PROBABILITY).push(postfix));
                }
            } else {
                state.output.fatal("If FloatVectorSpecies is going to use polynomial mutation as a per-gene or per-segment type, either the global or per-gene/per-segment random walk mutation probability must be defined.", base.push(P_RANDOM_WALK_PROBABILITY).push(postfix), def.push(P_RANDOM_WALK_PROBABILITY).push(postfix));
            }
        }
        if (mutType == 2 || mutType == 1 || mutType == 4) {
            if (state.parameters.exists(base.push(P_MUTATION_BOUNDED).push(postfix), def.push(P_MUTATION_BOUNDED).push(postfix))) {
                this.mutationIsBounded[index] = state.parameters.getBoolean(base.push(P_MUTATION_BOUNDED).push(postfix), def.push(P_MUTATION_BOUNDED).push(postfix), true);
            } else if (!this.mutationIsBoundedDefined) {
                state.output.fatal("If FloatVectorSpecies is going to use gaussian, polynomial, or integer random walk mutation as a per-gene or per-segment type, the mutation bounding must be defined.", base.push(P_MUTATION_BOUNDED).push(postfix), def.push(P_MUTATION_BOUNDED).push(postfix));
            }
        }
    }
}

