/*
 * Copyright 2016 by Romaric Pighetti, CNRS, I3S
 * Licensed under the Academic Free License version 3.0
 */
package fr.unice.i3s.keia.irWithIga.fitness;

import ec.Fitness;
import ec.multiobjective.MultiObjectiveFitness;

public class MObiDE_Fitness extends MultiObjectiveFitness {
	public static final String MOBIDE_RANK_PREAMBLE = "Rank: ";
	public static final String MOBIDE_HYPERVOLUME_PREAMBLE = "Hypervolume: ";

	public String[] getAuxilliaryFitnessNames() { return new String[] { "Rank", "Hypervolume" }; }
	public double[] getAuxilliaryFitnessValues() { return new double[] { rank, hypervolume }; }

	/** Pareto front rank measure (lower ranks are better) */
	public int rank;

	/** Hypervolume along front rank measure (higher hypervolume is better) */
	public double hypervolume;

    /**
     * MoBiDE implem / individual
     *(!) circular reference between fitness and corresponding individual instantce
     */
	public ec.Individual individual;

	public boolean betterThan(Fitness givenOther) {
        MObiDE_Fitness other = (MObiDE_Fitness) givenOther;
        return this.rank < other.rank || (this.rank == other.rank && this.hypervolume > other.hypervolume);
    }

}
