/*
 * Copyright 2016 by Romaric Pighetti, CNRS, I3S
 * Licensed under the Academic Free License version 3.0
 */
package fr.unice.i3s.keia.irWithIga.objective;

import ec.EvolutionState;
import ec.Individual;
import ec.Setup;

/**
 * Interface to define objective functions that can be used in problems.
 * Each objective is responsible of computing a specific measure for
 * individuals. This allows easier swapping of objectives for tests.
 *
 * @author pighetti
 *
 */
public interface Objective extends Setup {
    public double evaluate(EvolutionState state, Individual ind,
                           int subpopulation, int threadnum);

    public void setMultiplier(int multiplier);
}
