package ec.weka;

import ec.EvolutionState;
import ec.Individual;

public class StatisticsForWeka extends ec.Statistics {

    private static final long    serialVersionUID = 8272467899443777505L;

    public static Individual[][] bestOfJobs;

    public static boolean        staticBestInit   = false;

    /**
     * For checkpointing usage.
     */
    private Individual[][]       bestOfJobsCopy;

    /** The best individual we've found so far */
    private Individual[]         best_of_run;

    public Individual[] getBestSoFar() {
        return best_of_run;
    }

    public void postInitializationStatistics(final EvolutionState state) {
        super.postInitializationStatistics(state);

        // set up our best_of_run array -- can't do this in setup, because
        // we don't know if the number of subpopulations has been determined yet
        best_of_run = new Individual[state.population.subpops.length];
    }

    /** Logs the best individual of the generation. */
    public void postEvaluationStatistics(final EvolutionState state) {
        super.postEvaluationStatistics(state);

        // for now we just print the best fitness per subpopulation.
        Individual[] best_i = new Individual[state.population.subpops.length]; // quiets
        // compiler
        // complaints
        for (int x = 0; x < state.population.subpops.length; x++) {
            best_i[x] = state.population.subpops[x].individuals[0];
            for (int y = 1; y < state.population.subpops[x].individuals.length; y++)
                if (state.population.subpops[x].individuals[y].fitness
                        .betterThan(best_i[x].fitness))
                    best_i[x] = state.population.subpops[x].individuals[y];

            // now test to see if it's the new best_of_run
            if (best_of_run[x] == null
                    || best_i[x].fitness.betterThan(best_of_run[x].fitness))
                best_of_run[x] = (Individual) (best_i[x].clone());
        }
    }

    public void preCheckpointStatistics(final EvolutionState state) {
        this.bestOfJobsCopy = bestOfJobs;
    }
    
    public void putBestJobsFromCopy() {
        if(!staticBestInit) {
            bestOfJobs = this.bestOfJobsCopy;
            staticBestInit = true;
        }
    }
}
